/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.deadbeard;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.level.entities.SpellcasterZombie;
import com.github.teamfusion.rottencreatures.common.level.entities.lackey.Lackey;
import com.github.teamfusion.rottencreatures.common.level.entities.lackey.SkeletonLackey;
import com.github.teamfusion.rottencreatures.common.level.entities.lackey.ZombieLackey;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import com.github.teamfusion.rottencreatures.core.data.loot.RCLootTables;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class DeadBeard
extends SpellcasterZombie {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.defineId(DeadBeard.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_IGNITED = SynchedEntityData.defineId(DeadBeard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public DeadBeard(EntityType<? extends SpellcasterZombie> type, Level level) {
        super(type, level);
        this.xpReward = 20;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.createAttributes().add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0).add(Attributes.MAX_HEALTH, 70.0).add(Attributes.MOVEMENT_SPEED, 0.275).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ARMOR, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new SpellcasterZombie.CastingSpellGoal());
        this.goalSelector.addGoal(4, (Goal)new SummonLackeysGoal());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FUSE_ID, (Object)100);
        builder.define(DATA_IGNITED, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putShort("Fuse", (short)this.getFuse());
        tag.putBoolean("IsIgnited", this.isIgnited());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setFuse(tag.getShort("Fuse"));
        this.setIgnited(tag.getBoolean("IsIgnited"));
    }

    public void setFuse(int ticks) {
        this.getEntityData().set(DATA_FUSE_ID, (Object)ticks);
    }

    public int getFuse() {
        return (Integer)this.getEntityData().get(DATA_FUSE_ID);
    }

    public void setIgnited(boolean ignited) {
        this.getEntityData().set(DATA_IGNITED, (Object)ignited);
    }

    public boolean isIgnited() {
        return (Boolean)this.getEntityData().get(DATA_IGNITED);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.STONE_SWORD));
    }

    protected boolean isSunSensitive() {
        return false;
    }

    public boolean isBaby() {
        return false;
    }

    public void setBaby(boolean baby) {
    }

    private void explode() {
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 4.0f, Level.ExplosionInteraction.MOB);
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, source, recentlyHit);
        if (recentlyHit) {
            if (this.isIgnited()) {
                this.spawnAtLocation((ItemLike)RCBlocks.TNT_BARREL.get());
            }
            ItemStack chestStack = new ItemStack((ItemLike)RCBlocks.TREASURE_CHEST.get());
            CompoundTag customTag = new CompoundTag();
            customTag.putUUID("OwnerUUID", this.getUUID());
            Level level2 = this.level();
            if (level2 instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level2;
                LootParams builder = this.createTreasureLootContext(source, server);
                LootTable lootTable = server.getServer().reloadableRegistries().getLootTable(RCLootTables.TREASURE_CHEST);
                ObjectArrayList lootItems = lootTable.getRandomItems(builder);
                int targetMaxStackSize = lootItems.stream().filter(item -> !item.isEmpty()).findFirst().map(ItemStack::getMaxStackSize).orElse(-1);
                if (targetMaxStackSize > 0) {
                    ListTag itemsList = new ListTag();
                    int totalCount = 0;
                    for (ItemStack item2 : lootItems) {
                        if (item2.isEmpty() || item2.getMaxStackSize() != targetMaxStackSize) continue;
                        if (totalCount >= targetMaxStackSize) break;
                        int toAdd = Math.min(item2.getCount(), targetMaxStackSize - totalCount);
                        ItemStack stackToAdd = item2.copy();
                        stackToAdd.setCount(toAdd);
                        CompoundTag itemTag = new CompoundTag();
                        itemTag.putString("id", BuiltInRegistries.ITEM.getKey((Object)stackToAdd.getItem()).toString());
                        itemTag.putInt("Count", stackToAdd.getCount());
                        CustomData data = (CustomData)stackToAdd.get(DataComponents.CUSTOM_DATA);
                        if (data != null && !data.isEmpty()) {
                            itemTag.put("tag", (Tag)data.copyTag());
                        }
                        itemsList.add((Object)itemTag);
                        totalCount += toAdd;
                    }
                    customTag.put("Items", (Tag)itemsList);
                    customTag.putInt("ItemCount", totalCount);
                    customTag.putInt("MaxStackSize", targetMaxStackSize);
                }
            }
            chestStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customTag));
            this.spawnAtLocation(chestStack);
        }
    }

    private LootParams createTreasureLootContext(DamageSource source, ServerLevel server) {
        LootParams.Builder builder = new LootParams.Builder(server).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
        if (this.lastHurtByPlayer != null) {
            builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
        }
        return builder.create(LootContextParamSets.ENTITY);
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)RCBlocks.DEAD_BEARD_HEAD.get());
    }

    public void tick() {
        super.tick();
        if (!this.isIgnited() && (double)this.getHealth() <= 10.0 && !this.isDeadOrDying()) {
            this.setIgnited(true);
            this.setFuse(100);
            this.level().playSound(null, this.blockPosition(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (this.isIgnited() && !this.isDeadOrDying()) {
            int cooldown = this.getFuse() - 1;
            this.setFuse(cooldown);
            if (cooldown <= 0) {
                this.discard();
                this.explode();
            }
        }
    }

    public boolean canAttack(LivingEntity entity) {
        return !this.isIgnited() && super.canAttack(entity);
    }

    protected boolean convertsInWater() {
        return false;
    }

    public static boolean checkDeadBeardSpawnRules(EntityType<DeadBeard> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return DeadBeard.checkAnyLightMonsterSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.canSeeSky(pos));
    }

    protected SoundEvent getAmbientSound() {
        return RCSoundEvents.DEAD_BEARD_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return RCSoundEvents.DEAD_BEARD_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return RCSoundEvents.DEAD_BEARD_DEATH.get();
    }

    class SummonLackeysGoal
    extends SpellcasterZombie.UseSpellGoal {
        private final TargetingConditions lackeyCountTargeting = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();

        SummonLackeysGoal() {
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            int zombies = DeadBeard.this.level().getNearbyEntities(ZombieLackey.class, this.lackeyCountTargeting, (LivingEntity)DeadBeard.this, DeadBeard.this.getBoundingBox().inflate(16.0)).size();
            int skeletons = DeadBeard.this.level().getNearbyEntities(SkeletonLackey.class, this.lackeyCountTargeting, (LivingEntity)DeadBeard.this, DeadBeard.this.getBoundingBox().inflate(16.0)).size();
            return DeadBeard.this.random.nextInt(4) + 1 > zombies + skeletons;
        }

        @Override
        protected void performSpellCasting() {
            ServerLevel server = (ServerLevel)DeadBeard.this.level();
            server.playSound(null, DeadBeard.this.blockPosition(), RCSoundEvents.DEAD_BEARD_CALL.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            for (int i = 0; i <= DeadBeard.this.random.nextInt(4); ++i) {
                Monster lackey;
                BlockPos pos = DeadBeard.this.blockPosition().offset(-2 + DeadBeard.this.random.nextInt(5), -1, -2 + DeadBeard.this.random.nextInt(5));
                Monster monster = lackey = DeadBeard.this.random.nextBoolean() ? (Monster)RCEntityTypes.ZOMBIE_LACKEY.get().create((Level)server) : (Monster)RCEntityTypes.SKELETON_LACKEY.get().create((Level)server);
                if (!(lackey instanceof Lackey)) continue;
                Lackey lackeyIn = (Lackey)lackey;
                lackey.moveTo(pos, 0.0f, 0.0f);
                lackey.setDeltaMovement(0.0, 0.5, 0.0);
                server.playSound(null, lackey.blockPosition(), SoundEvents.GRAVEL_BREAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                lackey.finalizeSpawn((ServerLevelAccessor)server, server.getCurrentDifficultyAt(pos), MobSpawnType.MOB_SUMMONED, null);
                lackeyIn.setLimitedLife(500);
                server.addFreshEntity((Entity)lackey);
            }
            DeadBeard.this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 1));
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }
    }
}

